-- Library and Use statements for IEEE packages
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity top is
port(
Clk   : in  std_logic;
--ClkA,ClkB   : in  std_logic;
A,B   : in std_logic;
out1, out2 : out std_logic
);

end top;

architecture behave of top is

signal A_Sig, B_sig, clk1, clk2 : std_logic;
signal A_Sig1, B_sig1 : std_logic;

component PLL01 is
    port(
        clki_i: in std_logic;
        clkop_o: out std_logic;
        clkos_o: out std_logic
    );
end component;

begin

MyPLL : PLL01 port map(
    clki_i=> clk,
    clkop_o=> clk1,
    clkos_o=> clk2
);

process(clk1)
begin
if rising_edge(clk1) then
	A_sig <= A ;
	A_sig1 <= A_sig; 
	
end if;
end process;
out1 <= A_sig1;

process(clk2)
begin
if rising_edge(clk2) then
	B_sig <= B ;
	B_sig1 <= B_sig and A_sig; 

end if;
end process;
out2 <= B_sig1;

end behave;